/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.StandardDrawingView;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.RolloverButtonToolBar;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoIOException;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.logo.util.UDFXMLHandler;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.action.BlockToolAction;
import DE.siemens.ad.pdraw.action.SaveDrawingAction;
import DE.siemens.ad.pdraw.action.SelectLogoAction;
import DE.siemens.ad.pdraw.action.WrapTextAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.standard.ImageBlockTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.TreeImageBlockTool;
import DE.siemens.ad.pdraw.util.GridInfo;
import DE.siemens.ad.pdraw.util.LayoutProducerXMLUDF;
import DE.siemens.ad.pdraw.util.LineGridPainter;
import DE.siemens.ad.pdraw.util.PageLinePainter;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.GuidVersionMgr;
import DE.siemens.ad.udf.LogoComfortUDFStatusLine;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFEditorInfo;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.UDFLibrary;
import DE.siemens.ad.udf.UDFMenuManager;
import DE.siemens.ad.udf.UDFPropertyPanel;
import DE.siemens.ad.udf.UDFTreeImageBlockTool;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.dom4j.Document;

public class LogoComfortUDF
extends LogoComfort {
    private UDFEditorInfo editorInfo = null;

    public void displayInfoWiringDiagram() {
        this.displayUsedRessources();
        this.displaySuitableHardware();
        WiringDiagram wd = ((LogoDrawing)this.drawing()).getWiringDiagram().getFup();
        Hashtable errors = wd.getErrors();
        Hashtable warnings = wd.getWarnings();
        if (!((Dictionary)errors).isEmpty() || !((Dictionary)warnings).isEmpty()) {
            Log.println(Language.getString("editor.documentName.macroEditor", "LMA") + ":");
        }
        this.displayDict(errors);
        this.displayDict(warnings);
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null || !(this.fMenuManager instanceof UDFMenuManager)) {
            this.fMenuManager = new UDFMenuManager(this);
        }
        return this.fMenuManager;
    }

    public View loadDocument(File document, ProgressListener progressListener) {
        if (document.getAbsolutePath().toLowerCase().endsWith(".lma")) {
            this.fView = this.createDrawingView();
            this.loadXmlFile(document);
            if (!this.verifyUDFPassword(document.getAbsolutePath())) {
                return null;
            }
            WiringDiagram wiringDiagram = ((LogoDrawing)this.drawing()).getWiringDiagram();
            wiringDiagram.addHardwareChangedListener(this);
            wiringDiagram.hardwareChanged(wiringDiagram.getHardware());
            this.showStatus(Language.getString("msg.readSuccessful", "Read successful"));
            SaveDrawingAction saveDrawingAction = (SaveDrawingAction)this.getActionFactory().getAction("SaveDrawingAction");
            this.getView().getModel().addModelFileListener(saveDrawingAction);
            return (View)((Object)this.fView);
        }
        if (document.getAbsolutePath().toLowerCase().endsWith(".udf")) {
            this.fView = this.createDrawingView();
            String absoluteFilename = document.getAbsolutePath();
            try {
                this.loadDrawing(absoluteFilename, progressListener);
            }
            catch (LogoIOException e) {
                e.printStackTrace();
            }
            this.drawing().setStorePath(absoluteFilename);
            ((LogoDrawing)this.drawing()).setModified(false);
            WiringDiagram wiringDiagram = ((LogoDrawing)this.drawing()).getWiringDiagram();
            wiringDiagram.addHardwareChangedListener(this);
            wiringDiagram.hardwareChanged(wiringDiagram.getHardware());
            this.showStatus(Language.getString("msg.readSuccessful", "Read successful"));
            SaveDrawingAction saveDrawingAction = (SaveDrawingAction)this.getActionFactory().getAction("SaveDrawingAction");
            this.getView().getModel().addModelFileListener(saveDrawingAction);
            return (View)((Object)this.fView);
        }
        return null;
    }

    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        LogoDrawingViewUDF view = new LogoDrawingViewUDF(this, d.width, d.height);
        CSH.setHelpIDString((Component)view, (String)"window.DrawingView");
        GridInfo gridInfo = new GridInfo(view);
        view.setGridInfo(gridInfo);
        view.setAutoscrolls(false);
        view.addBackground(new PageLinePainter());
        view.addBackground(new LineGridPainter(view.getGridInfo()));
        return view;
    }

    protected Drawing createDrawing() {
        LogoDrawingUDF ld = new LogoDrawingUDF(true);
        this.setHardware(((LogoDrawing)ld).getWiringDiagram().getHardware());
        return ld;
    }

    protected TreeImageBlockTool createBlockToolTree(BlockGroup rootBlockGroup) {
        return new UDFTreeImageBlockTool(rootBlockGroup);
    }

    protected BlockToolAction[] createBlockToolActions() {
        int i;
        BlockToolAction[] blockToolActions = null;
        if (this.fHardware == null) {
            blockToolActions = new BlockToolAction[]{};
            return blockToolActions;
        }
        BlockGroup rootBlockGroup = this.getBlockGroup();
        int udfGroupCnt = 0;
        String udfGroupName = Language.getString("blockGroup.UDF", "UDF");
        for (i = 0; i < rootBlockGroup.getElementCount(); ++i) {
            if (!udfGroupName.equals(((BlockGroup)rootBlockGroup.getElementAt(i)).getName())) continue;
            ++udfGroupCnt;
        }
        blockToolActions = new BlockToolAction[rootBlockGroup.getElementCount() - udfGroupCnt];
        for (i = 0; i < rootBlockGroup.getElementCount(); ++i) {
            BlockGroup blockGroup = (BlockGroup)rootBlockGroup.getElementAt(i);
            if (udfGroupName.equals(blockGroup.getName())) continue;
            ImageBlockTool tool = new ImageBlockTool(blockGroup);
            BlockToolAction bta = (BlockToolAction)this.getActionFactory().getAction("BlockToolAction", "BlockToolAction" + i);
            bta.setIcon(blockGroup.getName() + "Icon");
            bta.setTextKey("block." + blockGroup.getName());
            bta.setDefaultText(blockGroup.getName());
            bta.setTool(tool);
            blockToolActions[i] = bta;
        }
        this.resetBlockToolTree(rootBlockGroup);
        return blockToolActions;
    }

    public boolean specifiedValidVersionNum() {
        if (!this.needToForceNewVersion()) {
            return true;
        }
        GuidVersionMgr mgr = ((WiringDiagramUDF)((LogoDrawing)this.drawing()).getWiringDiagram()).getUDFBlock().getGuidManager();
        if (!mgr.isSpecified()) {
            return true;
        }
        SpecifyVesionPanel dialog = new SpecifyVesionPanel(mgr);
        SplittedDlg dlg = SplittedDlg.create(null, dialog, 3);
        dlg.setTitle(Language.getString("dialog.info.udf.version.title", "Specify new version"));
        dlg.show();
        return dlg.getControlPanel().getResult() == 1;
    }

    protected boolean verifyUDFPassword(String filePath) {
        ApplicationSurface parent = Application.getInstance().getActiveApplicationSurface();
        UDFBlock udfBlock = ((WiringDiagramUDF)((LogoDrawing)this.drawing()).getWiringDiagram()).getUDFBlock();
        if (udfBlock.isPasswordDestroyed()) {
            this.showDestroyErrorDialog(parent, filePath);
            return false;
        }
        if (Util.isEmptyString(udfBlock.getPassword())) {
            return true;
        }
        UDFPasswordPanel panel = new UDFPasswordPanel(filePath, udfBlock.getPassword());
        SplittedDlg dlg = SplittedDlg.create(null, panel, 3);
        dlg.setTitle(Language.getString("dialog.info.udf.password.confirm.title", "UDF password"));
        dlg.show();
        return dlg.getControlPanel().getResult() == 1;
    }

    private void showDestroyErrorDialog(Component parent, String udfpath) {
        Object[] info = new Object[]{udfpath};
        new LogoError(parent, "dialog.error.udf.openfile.destroy", "The UDF file has been destroyed. LOGO!Soft Comfort can not open this file.(" + udfpath + ")", info, 0, 0).display();
    }

    private boolean needToForceNewVersion() {
        return true;
    }

    protected boolean loadXmlFile(File file) {
        Document document = UDFXMLHandler.loadDocument(file.getAbsolutePath());
        try {
            String hardwareName = document.getRootElement().valueOf("@hardware");
            Hardware hardware = HardwareFactory.getInstance().createInstance(hardwareName);
            this.initDrawing();
            this.drawing().setStorePath(file.getAbsolutePath());
            WiringDiagram wd = hardware.compileWDFromXml(document);
            this.setWiringDiagram(wd);
            ((LogoDrawingUDF)this.drawing()).getUDFCommentTextFigure().setText(((WiringDiagramUDF)wd).getUDFBlock().getComment());
            LayoutProducerXMLUDF layoutProducer = new LayoutProducerXMLUDF(this.view(), document);
            layoutProducer.layout();
            this.setZoomValue(((LogoDrawingView)this.view()).getZoomManager().getZoom());
            return true;
        }
        catch (Exception e) {
            Object[] arr = new String[]{file.getPath()};
            new LogoError((Component)this.getApplication().getActiveApplicationSurface(), "error.openFile", "Loading " + file.getPath() + " failed", arr, 0, 0).display();
            return false;
        }
    }

    public EditorInfo getEditorInfo() {
        if (this.editorInfo == null) {
            this.editorInfo = new UDFEditorInfo();
        }
        return this.editorInfo;
    }

    protected void saveAsXML(File file) {
        Hardware hw = ((LogoDrawingUDF)this.drawing()).getWiringDiagram().getHardware();
        String hwName = "null";
        if (hw != null) {
            hwName = hw.getName();
        }
        Document document = UDFXMLHandler.createDocument(hwName);
        hw.getUDFToXmlStorer().compile((LogoDrawingView)this.view(), document.getRootElement());
        UDFXMLHandler.storeDocument(file.getAbsolutePath(), document);
        if (UDFLibrary.isUDFSelected(file.getAbsolutePath())) {
            int validity = 0;
            if (((LogoDrawingUDF)this.drawing()).getWiringDiagram().getErrors().size() > 0) {
                Enumeration errors = ((LogoDrawingUDF)this.drawing()).getWiringDiagram().getErrors().keys();
                if (errors.hasMoreElements()) {
                    String error = (String)errors.nextElement();
                    validity = error.equals("msg.notReachableBlocks") ? 21 : (error.equals("msg.noBlocks") ? 22 : 2);
                }
            } else if (((LogoDrawingUDF)this.drawing()).getWiringDiagram().getWarnings().size() > 0) {
                validity = 1;
            }
            UDFFactory.instance().updateUDFRelated(file.getAbsolutePath(), ((WiringDiagramUDF)((LogoDrawingUDF)this.drawing()).getWiringDiagram()).getUDFBlock().getIdentifier(), ((WiringDiagramUDF)((LogoDrawingUDF)this.drawing()).getWiringDiagram()).getUDFBlock().getGuidManager(), validity);
        }
    }

    protected void saveAsObjectOutput(File file, ProgressListener progressListener) throws IOException, FileNotFoundException {
        super.saveAsObjectOutput(file, progressListener);
    }

    protected void addTools(JToolBar palette) {
        ActionFactory actionFactory = this.getActionManager().getActionFactory();
        RolloverButtonToolBar toolbar = (RolloverButtonToolBar)palette;
        toolbar.add((LogoToggleAction)actionFactory.getAction("SelectionToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("ConnectionToolAction"));
        BlockToolAction[] blockToolActions = this.getBlockToolActions();
        for (int i = 0; i < blockToolActions.length; ++i) {
            toolbar.add(blockToolActions[i]);
        }
        toolbar.add((LogoToggleAction)actionFactory.getAction("ConnectedTextToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("CutConnectToolAction"));
        toolbar.add((LogoToggleAction)actionFactory.getAction("SimulationToolAction"));
    }

    public void editDrawingProperties() {
        UDFPropertyPanel propertyPanel = new UDFPropertyPanel((LogoDrawingUDF)this.drawing());
        SplittedDlg dialog = SplittedDlg.create(this.getApplicationSurface().getWindow(), propertyPanel, 11);
        dialog.show();
    }

    public void selectionChanged(DrawingView view) {
        ActionFactory actionFactory = this.getActionManager().getActionFactory();
        int selectedFigureCount = view.selectionCount();
        Iterator figures = view.selection().iterator();
        boolean onlySelUDFBoxFigure = selectedFigureCount == 1 && view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getEditUDFFigure());
        boolean selMiniFlg = false;
        boolean selBlkFlg = false;
        while (figures.hasNext()) {
            Figure figure = (Figure)figures.next();
            if (figure instanceof EditUDFFigure.MiniBlockFigure) {
                selMiniFlg = true;
                continue;
            }
            if (!(figure instanceof BlockFigure)) continue;
            selBlkFlg = true;
        }
        boolean greaterZero = selectedFigureCount > 0;
        boolean onlyMini = selMiniFlg && !selBlkFlg;
        boolean multiBlock = selMiniFlg && selBlkFlg;
        actionFactory.getAction("CutAction").setActivated(!onlySelUDFBoxFigure && greaterZero && !onlyMini && !multiBlock);
        actionFactory.getAction("CopyAction").setActivated(!onlySelUDFBoxFigure && greaterZero && !onlyMini && !multiBlock);
        actionFactory.getAction("DeleteFiguresAction").setActivated(!onlySelUDFBoxFigure && greaterZero);
        actionFactory.getAction("MarkedToFrontAction").setActivated(greaterZero);
        actionFactory.getAction("MarkedToBackAction").setActivated(greaterZero);
        boolean greaterOne = selectedFigureCount > 1;
        actionFactory.getAction("AlignBlocksAutomaticallyAction").setActivated(greaterOne);
        actionFactory.getAction("AlignHorizontalAction").setActivated(greaterOne && !onlyMini && !multiBlock);
        actionFactory.getAction("AlignVerticalAction").setActivated(greaterOne && !onlyMini && !multiBlock);
        actionFactory.getAction("SpaceHorizontalAction").setActivated(greaterOne && !onlyMini && !multiBlock);
        actionFactory.getAction("SpaceVerticalAction").setActivated(greaterOne && !multiBlock);
        actionFactory.getAction("SnapToGridAction").setActivated(greaterZero && this.getGridInfo().gridAttractionIsOn());
        boolean singleBlockSelection = selectedFigureCount == 1 && view.selection().elementAt(0) instanceof BlockFigure && !(view.selection().elementAt(0) instanceof EditUDFFigure.MiniBlockFigure);
        actionFactory.getAction("EditBlockPropertiesAction").setActivated(singleBlockSelection);
        boolean singleCommentSelection = selectedFigureCount == 1 && view.selection().elementAt(0) instanceof CommentTextFigure;
        actionFactory.getAction("WrapTextAction").setActivated(singleCommentSelection);
        if (singleCommentSelection) {
            ((WrapTextAction)actionFactory.getAction("WrapTextAction")).setSelected(((CommentTextFigure)view.selection().elementAt(0)).isWrapText());
        } else {
            ((WrapTextAction)actionFactory.getAction("WrapTextAction")).setSelected(false);
        }
    }

    protected void setMessageRTFActivated(Hardware newHardware) {
        this.getActionFactory().getAction("MessageGlobalSettingAction").setActivated(false);
    }

    protected void setOnlineTestActivated(Hardware newHardware) {
        this.getActionFactory().getAction("OnlineTestToolAction").setActivated(false);
    }

    protected void open() {
        super.open();
        this.fStatusLine = new LogoComfortUDFStatusLine();
        SelectLogoAction selectLogoAction = (SelectLogoAction)this.getActionFactory().getAction("SelectLogoAction");
        ((LogoComfortUDFStatusLine)this.fStatusLine).addHardwareClickedListener(selectLogoAction);
    }

    public void saveDocument(File file, ProgressListener progressListener) throws IOException, FileNotFoundException, ProgramException {
        String lowerCaseFileName;
        GuidVersionMgr mgr = ((WiringDiagramUDF)((LogoDrawing)this.drawing()).getWiringDiagram()).getUDFBlock().getGuidManager();
        if (!mgr.isSpecified()) {
            mgr.addGuid("1.0.0", Long.valueOf(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt(100))));
        }
        if ((lowerCaseFileName = file.getName().toLowerCase()).endsWith(".udf")) {
            this.saveAsObjectOutput(file, progressListener);
            ((LogoDrawing)this.drawing()).setModified(false);
            return;
        }
        super.saveDocument(file, progressListener);
    }

    public static class UDFPasswordPanel
    extends DataInputPanel {
        private String udfFilePath = null;
        private String password = null;
        private JPasswordField pwdField;

        public UDFPasswordPanel(String udfPath, String udfPwd) {
            this.udfFilePath = udfPath;
            this.password = udfPwd;
            JPanel pwdPanel = new JPanel(new GridBagLayout());
            this.add(pwdPanel);
            JLabel infoLabel = new JLabel(Language.getString("dialog.info.udf.password.confirm.content", "Enter password to open UDF file"));
            JLabel pathInfoLabel = new JLabel(this.udfFilePath);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets(5, 0, 0, 0);
            constraints.anchor = 17;
            pwdPanel.add((Component)infoLabel, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.anchor = 17;
            pwdPanel.add((Component)pathInfoLabel, constraints);
            this.pwdField = new JPasswordField();
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.insets = new Insets(5, 0, 0, 0);
            constraints.anchor = 17;
            constraints.fill = 2;
            pwdPanel.add((Component)this.pwdField, constraints);
        }

        public boolean checkChanged() {
            return true;
        }

        public boolean checkFieldContents() {
            if (!Util.isObjectEqual(String.valueOf(this.pwdField.getPassword()), this.password)) {
                Object[] info = new Object[]{this.udfFilePath};
                new LogoError(null, "dialog.error.udf.openfile.password", "The password is incorrect. LOGO!Soft Comfort can not open the UDF file.(" + this.udfFilePath + ")", info, 0, 0).display();
                return false;
            }
            return true;
        }

        public void storeFieldContents() {
        }
    }

    public class SpecifyVesionPanel
    extends DataInputPanel {
        private static final long serialVersionUID = 1L;
        private EditableNumericSpinner highVerTextField = new EditableNumericSpinner();
        private EditableNumericSpinner midVerTextField = new EditableNumericSpinner();
        private EditableNumericSpinner lowVerTextField = new EditableNumericSpinner();
        private GuidVersionMgr guidVersionMgr;

        public SpecifyVesionPanel(GuidVersionMgr guidMgr) {
            this.guidVersionMgr = guidMgr;
            this.highVerTextField.setMin(0);
            this.highVerTextField.setMax(255);
            String[] vers = GuidVersionMgr.getVersionFromLong(GuidVersionMgr.getLongValueOfVer(this.guidVersionMgr.getVersion()) + 1L).split("\\.");
            int high = Integer.parseInt(vers[0]);
            int mid = Integer.parseInt(vers[1]);
            int low = Integer.parseInt(vers[2]);
            this.highVerTextField.setValue(high);
            this.midVerTextField.setMin(0);
            this.midVerTextField.setMax(255);
            this.midVerTextField.setValue(mid);
            this.lowVerTextField.setMin(0);
            this.lowVerTextField.setMax(255);
            this.lowVerTextField.setValue(low);
            JPanel topPanel = new JPanel();
            this.add(topPanel);
            topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            topPanel.setLayout(new BoxLayout(topPanel, 1));
            JPanel panel = new JPanel();
            topPanel.add(panel);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 0;
            gb.insets = new Insets(2, 4, 2, 4);
            if (this.guidVersionMgr.getVersion() != null) {
                panel.add((Component)new JLabel(Language.getString("dialog.info.udf.version.old", "Old version:")), gb);
                gb.gridx = 1;
                gb.fill = 2;
                JTextField j = new JTextField(this.guidVersionMgr.getVersion());
                j.setEditable(false);
                panel.add((Component)j, gb);
                gb.fill = 0;
                gb.gridx = 0;
                ++gb.gridy;
            }
            panel.add((Component)new JLabel(Language.getString("dialog.info.udf.version.new", "New version:")), gb);
            gb.gridx = 1;
            JPanel verPanel = new JPanel();
            verPanel.setLayout(new BoxLayout(verPanel, 0));
            verPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            verPanel.add(this.highVerTextField);
            JLabel l = new JLabel(":");
            l.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            verPanel.add(l);
            verPanel.add(this.midVerTextField);
            l = new JLabel(":");
            l.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            verPanel.add(l);
            verPanel.add(this.lowVerTextField);
            panel.add((Component)verPanel, gb);
            topPanel.add(Box.createVerticalStrut(10));
            JPanel buttonPanel = new JPanel();
            topPanel.add(buttonPanel);
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 3, 10));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        }

        public boolean checkFieldContents() {
            if (this.guidVersionMgr.getVersion() != null && GuidVersionMgr.getLongValueOfVer(this.guidVersionMgr.getVersion()) >= GuidVersionMgr.getLongValueOfVer(this.getVersion())) {
                JOptionPane.showMessageDialog(null, Language.getString("dialog.error.udfBadVersion.msg", "New version should be greater than old version!"), Language.getString("dialog.error.udfBadVersion.title", "Bad new version"), 0);
                return false;
            }
            return true;
        }

        public void storeFieldContents() {
            this.guidVersionMgr.addGuid(this.getVersion(), Long.valueOf(String.valueOf(System.currentTimeMillis()) + String.valueOf(new Random().nextInt(100))));
            ((LogoDrawing)LogoComfortUDF.this.drawing()).getWiringDiagram().getDrawingProperties().setVersion(this.getVersion());
        }

        public String getVersion() {
            return "" + this.highVerTextField.getValue() + "." + this.midVerTextField.getValue() + "." + this.lowVerTextField.getValue();
        }
    }
}

